<?php $_SESSION['tokenMuaf'] = true; ?>

<div class="box-">
  <h1>Logo and Theme Settings</h1>
</div>

<div class="clear" style="height: 10px;"></div>

<div id="setting-response" style="margin-bottom: 15px;"></div>

<div class="setting-card">
  <div class="setting-item">
    <div class="setting-info">
      <strong>Site Theme</strong>
      <p>Select which theme to use for the website.</p>
      <select name="settings[theme]" class="setting-select" data-setting-name="theme">
        <option value="">- select theme -</option>
        <?php 
        foreach ($themes as $theme): 
            if ($theme!='static'):
        ?>
          <option value="<?= $theme ?>" <?= setting('theme') == $theme ? 'selected' : null ?>><?= $theme ?></option>
        <?php 
            endif;
        endforeach; 
        ?>
      </select>
    </div>
  </div>
</div>

<div class="setting-card">
    <div class="setting-item">
        <div class="setting-info">
            <strong>Logo URL</strong>
            <p>Enter the logo URL or upload an image.</p>
            <input type="text" name="settings[logo]" data-setting-name="logo" value="<?= setting('logo') ?>" class="setting-input" placeholder="https://...">
            <input type="file" class="setting-upload" data-upload-type="logo">
            <div id="preview-logo" style="margin-top:8px;">
            <?php if (setting('logo')): ?>
                <img src="<?= setting('logo') ?>" alt="logo" style="max-height: 40px; border:1px solid #ccc; padding:4px;">
            <?php endif; ?>
            </div>
        </div>
  </div>

  <div class="setting-item">
        <div class="setting-info">
            <strong>Dark Logo URL</strong>
            <p>Enter the dark logo URL or upload an image.</p>
            <input type="text" name="settings[logo_dark]" data-setting-name="logo_dark" value="<?= setting('logo_dark') ?>" class="setting-input" placeholder="https://...">
            <input type="file" class="setting-upload" data-upload-type="logo_dark">
            <div id="preview-logo_dark" style="margin-top:8px;">
            <?php if (setting('logo_dark')): ?>
                <img src="<?= setting('logo_dark') ?>" alt="dark logo" style="max-height: 40px; border:1px solid #ccc; padding:4px;">
            <?php endif; ?>
            </div>
        </div>
  </div>
</div>

<div class="setting-card">
  <div class="setting-item">
    <div class="setting-info">
      <strong>Site Icon</strong>
      <p>Upload an image and we will generate favicon and app icons automatically.</p>
      <input type="file" class="setting-upload" data-upload-type="site_icon">
      <?php
      $iconPreviews = [
        'favicon_16'         => setting('favicon_16'),
        'favicon_32'         => setting('favicon_32'),
        'favicon_ico'        => setting('favicon_ico'),
        'apple_touch_icon'   => setting('apple_touch_icon'),
        'android_icon_192'   => setting('android_icon_192'),
        'android_icon_512'   => setting('android_icon_512')
      ];
      ?>
      <div id="site-icon-preview" style="margin-top: 10px;">
      <?php foreach ($iconPreviews as $key => $url): ?>
          <?php if ($url): ?>
          <div style="display:inline-block; margin-right:10px; text-align:center;">
              <img src="<?= $url ?>" alt="<?= $key ?>" style="width:48px; height:48px; border:1px solid #ccc; padding:4px; background:#fff;">
              <div style="font-size:11px; color:#666;"><?= $key ?></div>
          </div>
          <?php endif; ?>
      <?php endforeach; ?>
      </div>
    </div>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
  const responseBox = document.getElementById('setting-response');

  const showMessage = (type, text) => {
    responseBox.innerHTML = `<div class="alert alert-${type}">${text}</div>`;
    setTimeout(() => { responseBox.innerHTML = ''; }, 3000);
  };

  const saveSetting = (name, value) => {
    fetch('<?= admin_url('ajax/save-setting') ?>', {
      method: 'POST',
      headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
      body: `setting=${encodeURIComponent(name)}&value=${encodeURIComponent(value)}`
    })
    .then(res => res.json())
    .then(res => {
      if (res.success) {
        showMessage('success', 'Setting saved successfully.');
      } else {
        showMessage('error', res.message || 'An error occurred.');
      }
    })
    .catch(() => {
      showMessage('error', 'Network error!');
    });
  };

  document.querySelectorAll('.setting-toggle').forEach(el => {
    el.addEventListener('change', () => {
      saveSetting(el.dataset.settingName, el.checked ? 1 : 0);
    });
  });

  document.querySelectorAll('.setting-input, .setting-textarea, .setting-select').forEach(el => {
    el.addEventListener('blur', () => {
      saveSetting(el.dataset.settingName, el.value);
    });
    if (el.tagName === 'SELECT') {
      el.addEventListener('change', () => {
        saveSetting(el.dataset.settingName, el.value);
      });
    }
  });

  // ✅ Upload inputlarını dinle
  document.querySelectorAll('.setting-upload').forEach(input => {
    input.addEventListener('change', () => {
      const file = input.files[0];
      if (!file) return;

      const formData = new FormData();
      formData.append('upload_type', input.dataset.uploadType);
      formData.append('file', file);

      fetch('<?= admin_url('ajax/upload-setting-image') ?>', {
        method: 'POST',
        body: formData
      })
      .then(res => res.json())
      .then(res => {
        if (res.success) {
          showMessage('success', 'Upload successful.');
          
          // 🔄 Eğer ikon yüklediyse, önizleme alanına göster
          if (input.dataset.uploadType === 'site_icon' && res.icons) {
              const previewBox = document.getElementById('site-icon-preview');
              previewBox.innerHTML = `
                <div style="display:flex; flex-wrap:wrap; gap:10px;">
                ${Object.entries(res.icons).map(([key, url]) => `
                    <div style="text-align:center;">
                    <img src="${url}?v=${Date.now()}" alt="${key}" style="width:48px; height:48px; border:1px solid #ccc; padding:4px; background:#fff;">
                    <div style="font-size:11px; color:#666;">${key}</div>
                    </div>
                `).join('')}
                </div>
              `;
          }

          // 🎯 Logo ya da dark_logo ise input'u doldur
          const relatedInput = document.querySelector(`[data-setting-name="${input.dataset.uploadType}"]`);
          if (relatedInput) {
            relatedInput.value = res.url;
            const previewTarget = document.getElementById('preview-' + input.dataset.uploadType);
            if (previewTarget) {
            previewTarget.innerHTML = `<img src="${res.url}?v=${Date.now()}" alt="${input.dataset.uploadType}" style="max-height: 40px; border:1px solid #ccc; padding:4px;">`;
            }   
            saveSetting(input.dataset.uploadType, res.url);
          }
        } else {
          showMessage('error', res.message || 'Upload failed.');
        }
      })
      .catch(() => {
        showMessage('error', 'Upload error.');
      });
    });
  });
});
</script>