<?php $_SESSION['tokenMuaf'] = true; ?>

<div class="box-">
  <h1>General Settings</h1>
</div>

<div class="clear" style="height: 10px;"></div>

<div id="setting-response" style="margin-bottom: 15px;"></div>

<!-- Site Title -->
<div class="setting-card">
  <div class="setting-item">
    <div class="setting-info">
      <strong>Site Title</strong>
      <p>This will appear on browser tab and search engines.</p>
      <input type="text" name="settings[title]" data-setting-name="title" value="<?= setting('title') ?>" class="setting-input">
    </div>
  </div>
  <!-- Site URL -->
  <div class="setting-item">
    <div class="setting-info">
      <strong>Site URL</strong>
      <p>This is very important part, please check twice your input url address. Do not use http:// or https:// only your domain like example.com</p>
      <input type="text" name="settings[url]" data-setting-name="url" value="<?= setting('url') ?>" class="setting-input" placeholder="example.com">
    </div>
  </div>
  <!-- Site Email -->
  <div class="setting-item">
    <div class="setting-info">
      <strong>Site Email</strong>
      <p>This will appear in top menu and contact pages.</p>
      <input type="email" name="settings[email]" data-setting-name="email" value="<?= setting('email') ?>" class="setting-input">
    </div>
  </div>
  <!-- Site Phone -->
  <div class="setting-item">
    <div class="setting-info">
      <strong>Site Phone</strong>
      <p>This will appear in top menu and contact pages.</p>
      <input type="telephone" name="settings[telephone]" data-setting-name="telephone" value="<?= setting('telephone') ?>" class="setting-input">
    </div>
  </div>
  <!-- Founding Year -->
  <div class="setting-item">
    <div class="setting-info">
      <strong>Founded Year</strong>
      <p>This will use for informations in footer areas.</p>
      <input type="yil" name="settings[yil]" data-setting-name="yil" value="<?= setting('yil') ?>" class="setting-input">
    </div>
  </div>
</div>

<!-- Enable Multi Language -->
<div class="setting-card">
  <div class="setting-item">
    <div class="setting-toggle-wrapper">
      <label class="switch">
        <input type="checkbox" class="setting-toggle" data-setting-name="multilingual" <?= setting('multilingual') == 1 ? 'checked' : '' ?>>
        <span class="slider"></span>
      </label>
    </div>
    <div class="setting-info">
      <strong>Website Multilingual</strong>
      <p>Change website system to multilingual. Please contact with your customer expert for setting up new languages.</p>
    </div>
  </div>
</div>

<!-- Global Timezone Selector -->
<div class="setting-card">
  <div class="setting-item">
    <div class="setting-info">
      <strong>Website Timezone</strong>
      <p>
        Define the global timezone for your website. If <code>UTC</code> is selected, each user will see date/time according to their local timezone.
        Otherwise, all users will see the website using this selected timezone.
      </p>
      <select name="settings[global_timezone]" data-setting-name="global_timezone" class="setting-select">
        <option <?= setting('global_timezone') == 'UTC' ? ' selected ' : null ?> value="UTC">UTC (Universal Coordinated Time) (Default Timezone)</option>
        <?php
        $regions = [
          'Africa' => DateTimeZone::AFRICA,
          'America' => DateTimeZone::AMERICA,
          'Asia' => DateTimeZone::ASIA,
          'Atlantic' => DateTimeZone::ATLANTIC,
          'Australia' => DateTimeZone::AUSTRALIA,
          'Europe' => DateTimeZone::EUROPE,
          'Indian' => DateTimeZone::INDIAN,
          'Pacific' => DateTimeZone::PACIFIC
        ];
        foreach ($regions as $label => $mask):
          $zones = DateTimeZone::listIdentifiers($mask);
          if (empty($zones)) continue;
        ?>
          <optgroup label="<?= $label ?>">
            <?php foreach ($zones as $tz): ?>
              <option <?= setting('global_timezone') == $tz ? ' selected ' : null ?> value="<?= $tz ?>"><?= $tz ?></option>
            <?php endforeach; ?>
          </optgroup>
        <?php endforeach; ?>
      </select>
    </div>
  </div>
</div>

<!-- Membership Selector -->
<div class="setting-card">
  <div class="setting-item">
    <div class="setting-info">
      <strong>Membership Settings</strong>
      <p>Choose the login/register menus for the website interface.</p>
      <select name="settings[user_login]" data-setting-name="user_login" class="setting-select">
        <option <?=setting('user_login') == 1 ? ' selected ' : null?> value="1">Yes, in Top Bar</option>
        <option <?=setting('user_login') == 2 ? ' selected ' : null?> value="2">Yes, in Main Menu</option>
        <option <?=setting('user_login') == 0 ? ' selected ' : null?> value="0">No, hide login</option>
      </select>
    </div>
  </div>
</div>