<?php $_SESSION['tokenMuaf'] = true; ?>

<div class="box-">
  <h1>Footer Settings</h1>
</div>

<div class="clear" style="height: 10px;"></div>

<div id="setting-response" style="margin-bottom: 15px;"></div>

<div class="setting-card">

  <div class="setting-item">
    <div class="setting-info">
      <strong>Footer Background Image URL</strong>
      <p>Enter the image URL or upload an image. Dark images recommened.</p>
      <input type="text" name="settings[footer_bg_image]" data-setting-name="footer_bg_image" value="<?= setting('footer_bg_image') ?>" class="setting-input" placeholder="https://...">
      <input type="file" class="setting-upload" data-upload-type="footer_bg_image">
      <div id="preview-footer_bg_image" style="margin-top:8px;">
      <?php if (setting('footer_bg_image')): ?>
          <img src="<?= setting('footer_bg_image') ?>" alt="footer_bg_image" style="max-height: 40px; border:1px solid #ccc; padding:4px;">
      <?php endif; ?>
      </div>
    </div>
  </div>

  <div class="setting-item">
    <div class="setting-toggle-wrapper">
      <label class="switch">
        <input type="checkbox" class="setting-toggle" data-setting-name="maillist_footer"
               <?= setting('maillist_footer') == 1 ? 'checked' : '' ?>>
        <span class="slider"></span>
      </label>
    </div>
    <div class="setting-info">
      <strong>Maillist Form</strong>
      <p>Enable this to activate maillist form in footer area. Visitors may subscribe the maillist.</p>
    </div>
  </div>
  <?php foreach ($supportedLanguages as $lang):  ?>
  <div class="setting-item">
    <div class="setting-info">
      <strong>Footer About Text (<?= strtoupper($lang) ?>)</strong>
      <p>Custom message shown to footer area right side of footer logo. (Some tags are acceptable)</p>
      <textarea name="settings[footer_about_text_<?=$lang?>]" data-setting-name="footer_about_text_<?=$lang?>" class="setting-textarea"><?= setting('footer_about_text_' . $lang) ?></textarea>
    </div>
  </div>
  <?php endforeach; ?>
</div>

<div class="setting-card">

<?php 
$menus = $Veri->from('app_settings')->where('setting_key LIKE :key')->selectAll(['key' => 'menu_%']); 
foreach ($supportedLanguages as $lang): 
?>
  <div class="setting-item">
    <div class="setting-info">
      <strong>Footer Left Menu Title (<?= strtoupper($lang) ?>)</strong>
      <p>This will appear on browser tab and search engines.</p>
      <input type="text" name="settings[footer_menu1_title_<?=$lang?>]" data-setting-name="footer_menu1_title_<?=$lang?>" value="<?= setting('footer_menu1_title_' . $lang) ?>" class="setting-input">
    </div>
  </div>
  <div class="setting-item">
    <div class="setting-info">
      <strong>Footer Left Menu (<?= strtoupper($lang) ?>)</strong>
      <p>Footer area left first menu. <a href="<?=admin_url('settings/menus')?>">Click here for manage menus</a>.</p>
      <select class="setting-select" name="settings[footer_menu1_<?=$lang?>]" data-setting-name="footer_menu1_<?=$lang?>">
        <?php
        foreach ($menus as $row):
        ?>
          <option value="<?= $row['setting_key'] ?>" <?= setting('footer_menu1_' . $lang) === $row['setting_key'] ? 'selected' : '' ?>><?= $row['setting_key'] ?></option>
        <?php endforeach; ?>
      </select>
    </div>
  </div>

  <div class="setting-item">
    <div class="setting-info">
      <strong>Footer Middle Menu Title (<?= strtoupper($lang) ?>)</strong>
      <p>This will appear on browser tab and search engines.</p>
      <input type="text" name="settings[footer_menu2_title_<?=$lang?>]" data-setting-name="footer_menu2_title_<?=$lang?>" value="<?= setting('footer_menu2_title_' . $lang) ?>" class="setting-input">
    </div>
  </div>

  <div class="setting-item">
    <div class="setting-info">
      <strong>Footer Middle Menu (<?= strtoupper($lang) ?>)</strong>
      <p>Footer area left second menu. <a href="<?=admin_url('settings/menus')?>">Click here for manage menus</a>.</p>
      <select class="setting-select" name="settings[footer_menu2_<?=$lang?>]" data-setting-name="footer_menu2_<?=$lang?>">
        <?php
        foreach ($menus as $row):
        ?>
          <option value="<?= $row['setting_key'] ?>" <?= setting('footer_menu2_' . $lang) === $row['setting_key'] ? 'selected' : '' ?>><?= $row['setting_key'] ?></option>
        <?php endforeach; ?>
      </select>
    </div>
  </div>

  <div class="setting-item">
    <div class="setting-info">
      <strong>Footer Bottom Menu (<?= strtoupper($lang) ?>)</strong>
      <p>Footer area copyright section menu. <a href="<?=admin_url('settings/menus')?>">Click here for manage menus</a>.</p>
      <select class="setting-select" name="settings[footer_bottommenu_<?=$lang?>]" data-setting-name="footer_bottommenu_<?=$lang?>">
        <?php
        foreach ($menus as $row):
        ?>
          <option value="<?= $row['setting_key'] ?>" <?= setting('footer_bottommenu_' . $lang) === $row['setting_key'] ? 'selected' : '' ?>><?= $row['setting_key'] ?></option>
        <?php endforeach; ?>
      </select>
    </div>
  </div>
<?php endforeach; ?>

</div>

<div class="setting-card">
<?php foreach ($supportedLanguages as $lang): ?>
  <div class="setting-item">
    <div class="setting-info">
      <strong>Footer Custom HTML (<?= strtoupper($lang) ?>)</strong>
      <p>Custom HTML shown to footer area up of newsletter widget. (HTML tags are acceptable)</p>
      <textarea name="settings[footer_custom_html1_<?=$lang?>]" data-setting-name="footer_custom_html1_<?=$lang?>" class="setting-textarea"><?= setting('footer_custom_html1_' . $lang) ?></textarea>
    </div>
  </div>
  <div class="setting-item">
    <div class="setting-info">
      <strong>Footer Custom HTML (<?= strtoupper($lang) ?>)</strong>
      <p>Custom HTML shown to footer area down of newsletter widget. (HTML tags are acceptable)</p>
      <textarea name="settings[footer_custom_html2_<?=$lang?>]" data-setting-name="footer_custom_html2_<?=$lang?>" class="setting-textarea"><?= setting('footer_custom_html2_' . $lang) ?></textarea>
    </div>
  </div>
<?php endforeach; ?>
</div>

<script>
function showMessage(type, message) {
  const responseBox = document.getElementById('setting-response');
  if (!responseBox) return;

  const className = type === 'success' ? 'alert-success' : 'alert-danger';
  responseBox.innerHTML = `<div class="alert ${className}">${message}</div>`;
}

const saveSetting = (name, value) => {
  fetch('<?= admin_url('ajax/save-setting') ?>', {
    method: 'POST',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    body: `setting=${encodeURIComponent(name)}&value=${encodeURIComponent(value)}`
  });
}

document.addEventListener('DOMContentLoaded', function () {
  // ✅ Upload inputlarını dinle
  document.querySelectorAll('.setting-upload').forEach(input => {
    input.addEventListener('change', () => {
      const file = input.files[0];
      if (!file) return;

      const formData = new FormData();
      formData.append('upload_type', input.dataset.uploadType);
      formData.append('file', file);

      fetch('<?= admin_url('ajax/upload-setting-image') ?>', {
        method: 'POST',
        body: formData
      })
      .then(res => res.json())
      .then(res => {
        if (res.success) {
          showMessage('success', 'Upload successful.');

          const relatedInput = document.querySelector(`[data-setting-name="${input.dataset.uploadType}"]`);
          if (relatedInput) {
            relatedInput.value = res.url;

            const previewTarget = document.getElementById('preview-' + input.dataset.uploadType);
            if (previewTarget) {
              previewTarget.innerHTML = `<img src="${res.url}?v=${Date.now()}" alt="${input.dataset.uploadType}" style="max-height: 40px; border:1px solid #ccc; padding:4px;">`;
            }
          }

          saveSetting(input.dataset.uploadType, res.url);

        } else {
          showMessage('error', res.message || 'Upload failed.');
        }
      })
      .catch(() => {
        showMessage('error', 'Upload error.');
      });
    });
  });

  // Tıklanabilir HTML tag listesi
  const textarea = document.querySelector('textarea[name="settings[footer_about_text_en]"]');
  if (textarea) {
    const helper = document.createElement('div');
    helper.style.fontSize = '12px';
    helper.style.color = '#666';
    helper.style.marginTop = '4px';
    helper.innerHTML = 'Kullanabileceğiniz HTML tagları: ' +
      ['strong', 'em', 'br', 'a'].map(tag => `<a href="#" data-tag="${tag}" style="margin-right:5px;">&lt;${tag}&gt;</a>`).join('');
    
    textarea.parentNode.appendChild(helper);

    helper.querySelectorAll('a[data-tag]').forEach(link => {
      link.addEventListener('click', e => {
        e.preventDefault();
        const tag = e.target.dataset.tag;
        const insertText = tag === 'br' ? `<${tag}>` : `<${tag}></${tag}>`;

        const start = textarea.selectionStart;
        const end = textarea.selectionEnd;
        const text = textarea.value;

        textarea.value = text.substring(0, start) + insertText + text.substring(end);
        textarea.focus();
        textarea.selectionEnd = start + insertText.length;
      });
    });
  }
});
</script>