<?php $_SESSION['tokenMuaf'] = true; ?>

<div class="box-">
  <h1>Contact Settings</h1>
</div>

<div class="clear" style="height: 10px;"></div>

<div id="setting-response" style="margin-bottom: 15px;"></div>

<div class="setting-card">
  <div class="setting-item">
    <div class="setting-info">
      <strong>Website E-mail</strong>
      <p>This will appear in top menu and contact pages.</p>
      <input type="text" class="setting-input" data-setting-name="email" value="<?= setting('email') ?>" placeholder="info@example.com">
    </div>
  </div>

  <div class="setting-item">
    <div class="setting-info">
      <strong>Website Phone</strong>
      <p>This will appear in top menu and contact pages.</p>
      <input type="text" class="setting-input" data-setting-name="telephone" value="<?= setting('telephone') ?>" placeholder="+90 212 123 4567">
    </div>
  </div>
</div>

<div class="setting-card">
  <div class="setting-item">
    <div class="setting-info">
      <strong>Addresses</strong>
      <p>You can add multiple contact locations below.</p>
      <div id="addresses-list"></div>
      <button type="button" id="add-address-btn" class="btn btn-sm btn-secondary mt-2">+ Add Address</button>
    </div>
  </div>
</div>

<script>
  const addressesSetting = <?= json_encode(json_decode(htmlspecialchars_decode(setting('addresses') ?: '[]'))) ?>;
  const addressesList = document.getElementById('addresses-list');
  const addAddressBtn = document.getElementById('add-address-btn');

  const renderAddresses = () => {
    addressesList.innerHTML = '';
    addressesSetting.forEach((addr, i) => {
      const item = document.createElement('div');
      item.className = 'address-item';
      item.style = 'margin-bottom:15px; padding:10px; border:1px solid #ccc; border-radius:6px;';

      item.innerHTML = `
        <input type="text" placeholder="Title" value="${addr.title || ''}" class="form-control mb-1" data-field="title" data-index="${i}">
        <input type="text" placeholder="Email" value="${addr.email || ''}" class="form-control mb-1" data-field="email" data-index="${i}">
        <input type="text" placeholder="Phone" value="${addr.phone || ''}" class="form-control mb-1" data-field="phone" data-index="${i}">
        <textarea placeholder="Address" class="form-control mb-1" data-field="address" data-index="${i}">${addr.address || ''}</textarea>
        <button type="button" class="btn btn-danger btn-sm remove-address" data-index="${i}">Remove</button>
      `;
      addressesList.appendChild(item);
    });
  };

  const saveAddresses = () => {
    fetch('<?= admin_url('ajax/save-setting') ?>', {
      method: 'POST',
      headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
      body: `setting=addresses&value=${encodeURIComponent(JSON.stringify(addressesSetting))}`
    });
  };

  addressesList.addEventListener('input', e => {
    const index = e.target.dataset.index;
    const field = e.target.dataset.field;
    addressesSetting[index][field] = e.target.value;
    saveAddresses();
  });

  addressesList.addEventListener('click', e => {
    if (e.target.classList.contains('remove-address')) {
      const index = parseInt(e.target.dataset.index);
      addressesSetting.splice(index, 1);
      renderAddresses();
      saveAddresses();
    }
  });

  addAddressBtn.addEventListener('click', () => {
    addressesSetting.push({ title: '', email: '', phone: '', address: '' });
    renderAddresses();
    saveAddresses();
  });

  renderAddresses();
</script>