<!doctype html>
<html lang="en">
<head>

    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no"/>

    <meta charset="UTF-8">
    <title><?=setting('title')?> yönetim</title>

    <!--styles-->
    <link rel="stylesheet" href="<?= admin_public_url('styles/main.css') ?>">
    <link rel="stylesheet" href="<?= admin_public_url('styles/extra.css') ?>">

    <!--scripts-->
    <script src="<?= admin_public_url('scripts/jquery-1.12.2.min.js') ?>"></script>
    <script src="https://cdn.ckeditor.com/ckeditor5/39.0.0/classic/ckeditor.js"></script>
    <script src="<?= admin_public_url('scripts/admin.js') ?>"></script>

    <!-- Standard Favicon -->
    <?php if (setting('favicon_ico')): ?>
    <link rel="shortcut icon" href="<?= setting('favicon_ico') ?>" type="image/x-icon">
    <?php endif; ?>

</head>
<body>

<!--navbar-->
<div class="navbar">
    <ul dropdown>
        <li>
            <a href="<?=admin_url()?>">
                <span class="fa fa-home"></span>
                <span class="title">
            <strong>boa</strong>manager
        </span>
            </a>
        </li>
        <li>
            <a href="<?=site_url()?>" target="_blank">
                <span class="fa fa-share-square"></span>
                Siteye Git
            </a>
        </li>
        <li>
            <a href="#">
                <span class="fa fa-plus"></span>
                <span class="title">Ekle</span>
            </a>
            <ul>
                <li>
                    <a href="<?=admin_url('yeni-blog')?>">
                        Yeni Blog Yazısı
                    </a>
                </li>
            </ul>
        </li>
    </ul>
</div>

<!--sidebar-->
<div class="sidebar settings-sidebar">

    <ul>
        <?php foreach ($menus as $mainUrl => $menu): ?>
            <li class="<?=( ((_url(1) == $mainUrl) || isset($menu['submenu'][_url(1)])) ? 'active' : null )?>">
                <a href="<?=admin_url($mainUrl)?>">
                    <span class="fa fa-<?= $menu['icon'] ?>"></span>
                    <span class="title">
                        <?= $menu['title'] ?>
                    </span>
                </a>
                <?php if (isset($menu['submenu'])): ?>
                    <ul class="sub-menu">
                        <?php foreach ($menu['submenu'] as $url => $title): ?>
                            <?php if (str_starts_with($url, '___group:')): ?>
                                <li class="nav-group-title"><?= substr($url, 9) ?></li>
                                <?php continue; ?>
                            <?php endif; ?>
                            <li class="<?=
                                (_url(2) && $url == _url(1) . '/' . _url(2)) ? 'active' :
                                (!_url(2) && $url == _url(1) ? 'active' : null)
                            ?>">
                                <a href="<?=admin_url($url)?>">
                                    <?=$title?>
                                </a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                <?php endif; ?>
            </li>
        <?php endforeach; ?>
        <li class="line">
            <span></span>
        </li>
    </ul>
    <a href="#" class="collapse-menu">
        <span class="fa fa-arrow-circle-left"></span>
        <span class="title">
            Menüyü daralt
        </span>
    </a>

</div>

<!--content-->
<div class="content">
