<?php require admin_view('static/header') ?>

<?php 
if ((!_url(3))&&(_url(2))):

    $settingPage = 'static/settings/' . _url(2);
                            
    if (file_exists(admin_view($settingPage))):
        require admin_view($settingPage);
    endif;

else:
?>

    <div class="box-">
        <h1>Sistem Ayarları</h1>
    </div>

    <div class="clear" style="height: 10px;"></div>

    <?php
    if ( ( _url(2) == 'done' ) ):
        echo '
        <div class="box-container">
            <div class="box" id="div-0">
                <div class="box-content">
                    <p><strong>Ayarlar başarıyla güncellendi.</strong></p>
                </div>
            </div>
        </div>
        ';
    endif;
    ?>

    <?php
    // Arama & sayfalama
    $kelime = post('kelime') ?? null;
    $where = '1=1';
    $params = [];

    if ($kelime) {
        $where .= " AND (setting_key LIKE :q OR setting_value LIKE :q)";
        $params['q'] = '%' . $kelime . '%';
    }

    $ToplamKayit = $Veri->from('app_settings')->where($where)->count($params);

    $LIMITgosterimAdet = 20;
    $SayfaNo = get('sayfa') ? (int)get('sayfa') : 1;
    $LIMITilk = ($SayfaNo - 1) * $LIMITgosterimAdet;
    $ToplamSayfa = ceil($ToplamKayit / $LIMITgosterimAdet);

    $settings = $Veri->from('app_settings')
        ->where($where)
        ->order('updated_at DESC LIMIT ' . $LIMITilk .','. $LIMITgosterimAdet)
        ->selectAll($params);

    // Son güncellenen
    $SonAyar = $Veri->from('app_settings')
        ->where('setting_valid=:valid')
        ->order('updated_at DESC')
        ->selectOne(['valid' => 1]);
    ?>

    <div class="box-container">
        <div class="box" id="div-0">
            <h3>Toplam Ayar Sayısı &amp; En Son Güncellenen</h3>
            <div class="box-content">
                <p>
                    <font size="+1"><strong><?= $ToplamKayit ?></strong></font> Toplam Ayar
                    <?php if ($SonAyar): ?>
                        | Son güncelleme: <?= time_elapsed_string($SonAyar['updated_at']) ?> önce → 
                        <strong><?= $SonAyar['setting_key'] ?></strong>
                    <?php endif; ?>
                </p>
            </div>
        </div>
    </div>

    <div class="clear" style="height: 10px;"></div>

    <div class="box-">
        <form method="post" class="form label">
            <ul>
                <li>
                    <input type="text" name="kelime" value="<?= htmlspecialchars($kelime) ?>" placeholder="Ayar anahtarı veya değeri ara">
                    <button type="submit" name="ara"><i class="fa fa-search"></i></button>
                </li>
            </ul>
        </form>
    </div>

    <div class="table">
        <table>
            <thead>
            <tr>
                <th>#</th>
                <th>Ayar Anahtarı</th>
                <th>Değer</th>
                <th>Güncellendi</th>
                <th>İşlem</th>
            </tr>
            </thead>
            <tbody>
            <?php if ($settings): ?>
                <?php foreach ($settings as $row): ?>
                    <tr>
                        <td><?= $row['id'] ?></td>
                        <td><strong><?= htmlspecialchars($row['setting_key']) ?></strong></td>
                        <td style="font-size:12px"><?= mb_strimwidth(htmlspecialchars($row['setting_value']), 0, 80, '...') ?></td>
                        <td><?= time_elapsed_string($row['updated_at']) ?> önce</td>
                        <td>
                            <a onclick="return confirm('Bu ayarı silmek istediğinizden emin misiniz?')" href="<?= admin_url('ayarlar/sil?id=' . encryptData($row['id'])) ?>"><i class="fa fa-trash"></i></a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="5">Kayıt bulunamadı.</td>
                </tr>
            <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php if (!$kelime): ?>
        <div class="pagination">
            <ul>
                <li>Toplam <?= $ToplamKayit ?> kayıt ve <?= $ToplamSayfa ?> sayfa</li>
                <li> | </li>
                <?php for ($x = 1; $x <= $ToplamSayfa; $x++): ?>
                    <li<?= ($x == $SayfaNo ? ' class="active"' : null) ?>>
                        <a href="?sayfa=<?= $x ?>"><?= $x ?></a>
                    </li>
                <?php endfor; ?>
            </ul>
        </div>
    <?php endif; ?>

<?php endif; ?>
<?php require admin_view('static/footer') ?>

<script>
document.addEventListener('DOMContentLoaded', function () {
  const responseBox = document.getElementById('setting-response');

  const showMessage = (type, text) => {
    responseBox.innerHTML = `<div class="alert alert-${type}">${text}</div>`;
    setTimeout(() => { responseBox.innerHTML = ''; }, 3000);
  };

  const saveSetting = (name, value) => {
    fetch('<?= admin_url('ajax/save-setting') ?>', {
      method: 'POST',
      headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
      body: `setting=${encodeURIComponent(name)}&value=${encodeURIComponent(value)}`
    })
    .then(res => res.json())
    .then(res => {
      if (res.success) {
        showMessage('success', 'Setting saved successfully.');
      } else {
        showMessage('error', res.message || 'An error occurred.');
      }
    })
    .catch(() => {
      showMessage('error', 'Network error!');
    });
  };

  document.querySelectorAll('.setting-toggle').forEach(el => {
    el.addEventListener('change', () => {
      saveSetting(el.dataset.settingName, el.checked ? 1 : 0);
    });
  });

  document.querySelectorAll('.setting-input, .setting-textarea, .setting-select').forEach(el => {
    el.addEventListener('blur', () => {
      saveSetting(el.dataset.settingName, el.value);
    });
    if (el.tagName === 'SELECT') {
      el.addEventListener('change', () => {
        saveSetting(el.dataset.settingName, el.value);
      });
    }
  });
});
</script>