<?php
## ADMIN KONTROL
$kontrol->Admin(5);

$localVersion = include __DIR__ . '/../../app/version.php';

function fetchRemoteJson($url) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}

function applyPatch($url, $extractPath) {
    $tempZip = __DIR__ . '/update.zip';
    file_put_contents($tempZip, fopen($url, 'r'));

    $zip = new ZipArchive;
    if ($zip->open($tempZip) === TRUE) {
        $zip->extractTo($extractPath);
        $zip->close();
        unlink($tempZip);
        return true;
    }
    return false;
}

$updateUrl = 'https://downloads.boacore.com/update.json';
$updateInfo = fetchRemoteJson($updateUrl);

if (!$updateInfo || !isset($updateInfo['latest']) || !isset($updateInfo['patches'])) {
    die('Güncelleme bilgileri alınamadı.');
}

$patches = $updateInfo['patches'];
$current = $localVersion['version'];
$latest = $updateInfo['latest'];
$versionFile = __DIR__ . '/../../app/version.php';
$rootPath = __DIR__ . '/../../';
$logPath = $rootPath . 'logs/update-log.txt';

if (!is_dir(dirname($logPath))) {
    mkdir(dirname($logPath), 0775, true);
}

if (version_compare($latest, $current, '<=')) {
    die('Sistem zaten güncel.');
}

$errmsg = '';
while (isset($patches[$current])) {
    $next = $patches[$current];
    $patchUrl = $next['url'];
    $nextVersion = $next['to'];

    $success = applyPatch($patchUrl, $rootPath);
    if ($success) {
        // Versiyon dosyasını güncelle
        file_put_contents($versionFile, "<?php\nreturn ['version' => '$nextVersion'];\n");

        // Log ekle
        $log = "[" . date('Y-m-d H:i:s') . "] $current → $nextVersion\n";
        file_put_contents($logPath, $log, FILE_APPEND);

        $current = $nextVersion;
        $errmsg = $nextVersion;
    } else {
        $errmsg = "error";
        break;
    }
}

require admin_view('update');