<?php
header('Content-Type: application/json');

// ✅ İlk olarak gerekli kontrol ve değişken tanımı
if (!isset($_FILES['file']) || !$_POST['upload_type']) {
    echo json_encode(['success' => false, 'message' => 'Dosya alınamadı.']);
    exit;
}
  
$uploadType = $_POST['upload_type']; // <-- BU SATIR ERKEN GELMELİ
$tmpName = $_FILES['file']['tmp_name'] ?? '';
$allowed = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
$ext = strtolower(pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION));

if (!in_array($ext, $allowed)) {
    echo json_encode(['success' => false, 'message' => 'Geçersiz dosya türü.']);
    exit;
}
  
if ($uploadType === 'site_icon') {
    $imageSizes = [
        ['name' => 'favicon-16x16.png',  'width' => 16,  'height' => 16],
        ['name' => 'favicon-32x32.png',  'width' => 32,  'height' => 32],
        ['name' => 'favicon.ico',  'width' => 32,  'height' => 32],
        ['name' => 'apple-touch-icon.png', 'width' => 180, 'height' => 180],
        ['name' => 'android-chrome-192x192.png', 'width' => 192, 'height' => 192],
        ['name' => 'android-chrome-512x512.png', 'width' => 512, 'height' => 512]
    ];

    $outputDir = __DIR__ . '/../../../public/uploads/icons/';
    if (!is_dir($outputDir)) {
        mkdir($outputDir, 0755, true);
    }

    $original = imagecreatefromstring(file_get_contents($tmpName));
    foreach ($imageSizes as $icon) {
        $resized = imagecreatetruecolor($icon['width'], $icon['height']);
        imagealphablending($resized, false);
        imagesavealpha($resized, true);
        imagecopyresampled($resized, $original, 0, 0, 0, 0, $icon['width'], $icon['height'], imagesx($original), imagesy($original));
        imagepng($resized, $outputDir . $icon['name']);
        imagedestroy($resized);
    }

    imagedestroy($original);
    
    $settingsToSave = [
        'favicon_16'         => site_url('public/uploads/icons/favicon-16x16.png'),
        'favicon_32'         => site_url('public/uploads/icons/favicon-32x32.png'),
        'favicon_ico'        => site_url('public/uploads/icons/favicon.ico'),
        'apple_touch_icon'   => site_url('public/uploads/icons/apple-touch-icon.png'),
        'android_icon_192'   => site_url('public/uploads/icons/android-chrome-192x192.png'),
        'android_icon_512'   => site_url('public/uploads/icons/android-chrome-512x512.png'),
    ];
    
    save_settings($settingsToSave); // ✅ AYARLARA KAYDET
    
    echo json_encode([
        'success' => true,
        'message' => 'All icons generated and settings updated.',
        'icons' => $settingsToSave
    ]);
    exit;
}

// ✅ Gerçek yükleme dizini
$uploadDir = realpath(__DIR__ . '/../../../public/uploads/settings');
if (!$uploadDir) {
  $uploadDir = __DIR__ . '/../../../public/uploads/settings';
  if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0755, true);
  }
}

// ✅ Dosya adı ve yol
$fileName = $uploadType . '-' . time() . '.' . $ext;
$targetPath = $uploadDir . '/' . $fileName;
$relativePath = site_url('public/uploads/settings/' . $fileName);

// ✅ Yükleme işlemi
if (move_uploaded_file($_FILES['file']['tmp_name'], $targetPath)) {
  echo json_encode(['success' => true, 'url' => $relativePath]);
} else {
  echo json_encode(['success' => false, 'message' => 'Yükleme başarısız.']);
}