<?php
header('Content-Type: application/json');

global $Veri, $supportedLanguages;

try {
    $baseUrl = site_url();
    $urls = [];

    // Add plain root URL first
    $urls[] = [
        'loc' => rtrim($baseUrl, '/') . '/',
        'changefreq' => 'weekly',
        'priority' => '1.0'
    ];

    // Then add language-specific URLs
    foreach ($supportedLanguages as $lang) {
        $urls[] = [
            'loc' => rtrim($baseUrl, '/') . '/' . $lang . '/',
            'changefreq' => 'weekly',
            'priority' => '1.0'
        ];
    }

    // Retrieve manually added URLs
    $manualUrls = explode("\n", setting('sitemap_manual_urls') ?? '');
    foreach ($manualUrls as $manualUrl) {
        $manualUrl = trim($manualUrl);
        if ($manualUrl) {
            $urls[] = [
                'loc' => $baseUrl . $manualUrl,
                'changefreq' => 'weekly',
                'priority' => '0.8'
            ];
        }
    }

    // Check settings and fetch related URLs
    if (setting('sitemap_include_blog')) {
        $blogPosts = $Veri->from('icerik')->select('content_id,content_kod')->where('content_onay=:onay')->selectAll(['onay' => 1]);
        foreach ($blogPosts as $post) {
            $urls[] = [
                'loc' => $baseUrl . 'r/' . $post['content_kod'],
                'changefreq' => 'weekly',
                'priority' => '0.8'
            ];
        }
    }

    if (setting('sitemap_include_categories')) {
        $blogCategories = $Veri->from('icerik_kat')->select('cat_id,cat_kod')->where('cat_onay=:onay')->selectAll(['onay' => 1]);
        foreach ($blogCategories as $category) {
            $urls[] = [
                'loc' => $baseUrl . 'r/c/' . $category['cat_kod'],
                'changefreq' => 'weekly',
                'priority' => '0.8'
            ];
        }
    }

    if (setting('sitemap_include_support')) {
        $supportPages = $Veri->from('destek')->select('spt_id')->where('spt_onay=:onay AND spt_public=:onay AND spt_acik=:degil')->selectAll(['onay' => 1, 'degil' => 0]);
        foreach ($supportPages as $page) {
            $urls[] = [
                'loc' => $baseUrl . 'support/view/' . $page['spt_id'],
                'changefreq' => 'weekly',
                'priority' => '0.8'
            ];
        }
    }

    ob_start();
    echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    echo "<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n";

    foreach ($urls as $url) {
        echo "  <url>\n";
        echo "    <loc>" . htmlspecialchars($url['loc']) . "</loc>\n";
        echo "    <changefreq>" . $url['changefreq'] . "</changefreq>\n";
        echo "    <priority>" . $url['priority'] . "</priority>\n";
        echo "  </url>\n";
    }

    echo "</urlset>";
    $sitemapContent = ob_get_clean();

    $filePath = PATH . '/sitemap.xml';
    file_put_contents($filePath, $sitemapContent);

    // Save last generated timestamp
    save_settings(['sitemap_last_generated' => date('Y-m-d H:i:s')]);

    echo json_encode(['status' => 'success', 'message' => 'Sitemap generated successfully.']);
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
