<?php
header('Content-Type: application/json');

$rawInput = file_get_contents('php://input');
$data = json_decode($rawInput, true);

// Eğer JSON boşsa POST verisinden almayı dene
if (!$data && isset($_POST['key'])) {
    $data = ['key' => $_POST['key']];
}

if (!isset($data['key']) || !is_string($data['key'])) {
    echo json_encode(['success' => false, 'error' => 'Geçersiz parametre']);
    exit;
}

$key = $data['key'];

// Yalnızca "menu_" ile başlayan ayarlar silinebilir
if (strpos($key, 'menu_') !== 0) {
    echo json_encode(['success' => false, 'error' => 'İzin verilmeyen anahtar']);
    exit;
}

$result = $Veri->delete('app_settings')->where('setting_key=:key')->deleteOne(['key' => $key]);

if ($result) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'error' => 'Silme işlemi başarısız']);
}
exit;
